// extension/background.js

// This function opens the onboarding page.
function openOnboardingPage() {
    chrome.tabs.create({
      url: 'onboarding.html'
    });
  }
  
  // Listen for the onInstalled event.
  chrome.runtime.onInstalled.addListener((details) => {
    // Log the details to the service worker console to help debug.
    console.log('onInstalled event fired. Details:', details);
  
    // Check if the reason is the initial installation.
    if (details.reason === 'install') {
      console.log('Reason is "install". Opening onboarding page.');
      openOnboardingPage();
    } 
    // You can also add logic for updates in the future.
    // else if (details.reason === 'update') {
    //   console.log('Extension was updated.');
    // }
  });