document.addEventListener('DOMContentLoaded', () => {
    const notifyBtn = document.getElementById('notify-btn');
    const consentCheckbox = document.getElementById('consent-checkbox');
    const finishBtn = document.getElementById('finish-btn');

    let notificationPermission = false;
    let consentGiven = false;

    function checkPermissions() {
        if (notificationPermission && consentGiven) {
            finishBtn.disabled = false;
        }
    }

    // 1. Handle Notification Permission
    notifyBtn.addEventListener('click', async () => {
        const granted = await chrome.permissions.request({
            permissions: ['notifications']
        });

        if (granted) {
            notifyBtn.textContent = 'Permissions Granted!';
            notifyBtn.disabled = true;
            notificationPermission = true;
            checkPermissions();
        }
    });

    // 2. Handle Data Consent Checkbox
    consentCheckbox.addEventListener('change', () => {
        consentGiven = consentCheckbox.checked;
        checkPermissions();
    });

    // 3. Handle Finish Button
    finishBtn.addEventListener('click', () => {
        // Save the user's consent choice to storage
        chrome.storage.local.set({ dataConsent: true }, () => {
            console.log('User consent for data analysis has been saved.');
            // Close the onboarding tab
            chrome.tabs.getCurrent(tab => {
                if (tab) {
                    chrome.tabs.remove(tab.id);
                }
            });
        });
    });
});