/**
 * This script handles interactions for the popup.html welcome screen.
 */
document.addEventListener('DOMContentLoaded', () => {
  // Find the main call-to-action button by its class name.
  const dashboardBtn = document.querySelector('.cta-btn');

  // Check if the button exists on the page.
  if (dashboardBtn) {
    // Add a click event listener to the button.
    dashboardBtn.addEventListener('click', (event) => {
      // Prevent the default link behavior to handle it with the Chrome API.
      event.preventDefault(); 
      
      // Get the URL from the button's 'href' attribute.
      const url = dashboardBtn.href;

      // Use the Chrome tabs API to create a new tab.
      // This is the standard and safest way to open links from an extension.
      chrome.tabs.create({ url: url });
    });
  }

  // --- Optional: Add functionality to feature items ---
  // You can also make the "feature-item" divs clickable if you want.
  const featureItems = document.querySelectorAll('.feature-item');
  featureItems.forEach(item => {
    item.style.cursor = 'pointer'; // Make it look clickable
    item.addEventListener('click', () => {
      // For now, they can also open the main dashboard, or you can change the URL.
      chrome.tabs.create({ url: 'https://basic-five-eosin.vercel.app/dashboard.html' });
    });
  });
});